;
; MZ-700/1500 L[{[h̃eXgvO
;
	ORG	1200h

Y_OFFSET	EQU	4

KDD	MACRO
	DW	((%2+Y_OFFSET)*40+(%1)) | (%3 << 11)
	ENDM

;
; 擾L[{[h}gNX̏ (xx00hɒu)
;
KeyState:
	DB	0FFh, 00h
	DB	0FFh, 00h
	DB	0FFh, 00h
	DB	0FFh, 00h
	DB	0FFh, 00h
	DB	0FFh, 00h
	DB	0FFh, 00h
	DB	0FFh, 00h
	DB	0FFh, 00h
	DB	0FFh, 00h
KeyState_:

;
; L[{[h̃L[̊GVRAM̃ItZbgE
;
KeyDrawData:
	KDD	31,  7, 3	; Kana
	KDD	 1,  5, 2	; GRAPH
	KDD	29,  7, 1	; =
	KDD	 1,  7, 3	; Eisu
	DW	0
	KDD	24,  9, 1	; ;
	KDD	26,  9, 1	; :
	KDD	30,  9, 4	; CR

	KDD	15,  7, 1	; Y
	KDD	 7, 11, 1	; Z
	KDD	25,  7, 1	; @
	KDD	27,  7, 1	; (
	KDD	28,  9, 1	; )
	DW	0
	DW	0
	DW	0

	KDD	 5,  7, 1	; Q
	KDD	11,  7, 1	; R
	KDD	 8,  9, 1	; S
	KDD	13,  7, 1	; T
	KDD	17,  7, 1	; U
	KDD	13, 11, 1	; V
	KDD	 7,  7, 1	; W
	KDD	 9, 11, 1	; X

	KDD	19,  7, 1	; I
	KDD	18,  9, 1	; J
	KDD	20,  9, 1	; K
	KDD	22,  9, 1	; L
	KDD	19, 11, 1	; M
	KDD	17, 11, 1	; N
	KDD	21,  7, 1	; O
	KDD	23,  7, 1	; P

	KDD	 6,  9, 1	; A
	KDD	15, 11, 1	; B
	KDD	11, 11, 1	; C
	KDD	10,  9, 1	; D
	KDD	 9,  7, 1	; E
	KDD	12,  9, 1	; F
	KDD	14,  9, 1	; G
	KDD	16,  9, 1	; H

	KDD	 4,  5, 1	; 1
	KDD	 6,  5, 1	; 2
	KDD	 8,  5, 1	; 3
	KDD	10,  5, 1	; 4
	KDD	12,  5, 1	; 5
	KDD	14,  5, 1	; 6
	KDD	16,  5, 1	; 7
	KDD	18,  5, 1	; 8

	KDD	28,  5, 1	; *
	KDD	26,  5, 1	; +
	KDD	24,  5, 1	; -
	KDD	 9, 13, 17	; [SP]
	KDD	22,  5, 1	; 0
	KDD	20,  5, 1	; 9
	KDD	21, 11, 1	; ,
	KDD	23, 11, 1	; .

	KDD	32,  1, 3	; INST
	KDD	36,  1, 3	; DEL
	KDD	37,  6, 1	; Up
	KDD	37, 10, 1	; Down
	KDD	38,  8, 1	; Right
	KDD	36,  8, 1	; Left
	KDD	27, 11, 1	; ?
	KDD	25, 11, 1	; /

	KDD	30,  5, 4	; BREAK
	KDD	 1,  9, 4	; CTRL
	DW	0
	DW	0
	DW	0
	DW	0
	DW	0
	KDD	 1, 11, 5	; SHIFT

	KDD	 1,  1, 2	; F1
	KDD	 4,  1, 2	; F2
	KDD	 7,  1, 2	; F3
	KDD	10,  1, 2	; F4
	KDD	13,  1, 2	; F5
	DW	0
	DW	0
	DW	0

;
; L[{[heXg
;
Entry:
	LD	HL, 0D000h		; eLXgVRAM
	LD	DE, 0D001h
	LD	BC, 999
	LD	(HL), L
	LDIR

	LD	HL, 0D800h		; Agr[gVRAM
	LD	DE, 0D801h
	LD	BC, 999
	LD	(HL), 70h
	LDIR

	CALL	Decompress_LZSS		; L[{[h̊G\
@@:	CALL	KeyScan			; L[XL
	CALL	DrawKeyState		; ω̂L[`悷
	CALL	WaitVBLANK		; VBLANK҂
	JR	@b

;
; L[XL
;
KeyScan:
	LD	HL, KeyState
	LD	BC, (10 << 8) | 0F0h
@@:	LD	A, C
	PUSH	HL
	LD	HL, 0E001h
	LD	(0E000h), A
	LD	A, (HL)
	POP	HL
	LD	E, A
	LD	A, (HL)		; Last Key State
	LD	(HL), E		; Update Current Key State
	INC	L
	XOR	E
	LD	(HL), A		; Key State Changed
	INC	L
	INC	C
	DJNZ	@b
	RET

;
; ωL[̏Ԃ`悷
;
DrawKeyState:
	LD	HL, KeyState
@1:	LD	C, (HL)
	INC	L
	LD	A, (HL)
	INC	L
	LD	B, 8
@@:	RLC	C
	RLA
	CALL	C, DrawOneKey
	DJNZ	@b
	LD	A, L
	CP	(KeyState_) & 0FFh
	JR	C, @1b
	RET

DrawOneKey:
	EX	AF, AF'		;'
	LD	A, 8
	SUB	B		; A = {0-7} (Key Data bit)
	LD	E, A		; E = {0-7} (Key Data bit)
	LD	A, L
	SUB	2
	ADD	A, A
	ADD	A, A		; A = {0-10} (Row) << 3
	OR	E
	ADD	A, A
	BIT	0, C		; Make or Break?
	EXX
	LD	C, 70h		; Break
	JR	NZ, @f
	LD	C, 72h		; Make
@@:	LD	HL, KeyDrawData
	ADD	A, L
	LD	L, A
	ADC	A, H
	SUB	L
	LD	H, A
	LD	E, (HL)
	INC	HL
	LD	A, (HL)
	AND	0F8h
	JR	Z, @1f
	RRCA
	RRCA
	RRCA
	LD	B, A
	CP	5		; SHIFT ?
	JR	Z, @2f
	LD	A, (HL)
	AND	07h
	ADD	A, 0D8h
	LD	D, A
	LD	A, C
@3:	LD	(DE), A
	INC	DE
	DJNZ	@3b
@1:	EXX
	EX	AF, AF'		;'
	RET

@2:	LD	DE, 0D800h + 29 + (11+Y_OFFSET) * 40
	LD	A, C
@@:	LD	(DE), A
	INC	DE
	DJNZ	@b
	LD	DE, 0D800h + 1 + (11+Y_OFFSET) * 40
	LD	B, 5
	JR	@3b

;
; VBLANK҂
;
WaitVBLANK:
	LD	HL, 0E002h
	XOR	A
@@:	OR	(HL)
	JP	P, @b
@@:	AND	(HL)
	JP	M, @b
	RET

;
; LZSSňkꂽeLXgVRAM̃f[^WJ
;
Decompress_LZSS:
	LD	HL, KBD_PIC
	LD	DE, 0D000h + 40 * Y_OFFSET

	LD	BC, KBD_PIC_ - KBD_PIC + 1

Decomp_loop:
	LD	A, B
	OR	C
	RET	Z

	DEC	BC
	LD	A, (HL)
	INC	HL
	CP	0C1h
	JR	Z, LZSS_1
	CP	0C2h
	JR	Z, LZSS_1
	CP	0C6h
	JR	Z, LZSS_2
	LD	(DE), A
	INC	DE
	JR	Decomp_loop

LZSS_1:
	DEC	BC
	PUSH	BC
	LD	B, A
	LD	A, (HL)
	INC	HL
	PUSH	HL
	LD	C, A

	AND	0F8h
	SRL	B		; C1:Cy=1, C2:Cy=0
	CCF			; C1:Cy=0, C2:Cy=1
	RRA
	RRCA
	RRCA
	INC	A		; A = delta
	LD	B, A
	LD	A, E		; E -= (d+1)
	SUB	B
	LD	L, A
	LD	H, D
	JR	NC, @f
	DEC	H
@@:				; HL = src
	LD	A, C
	AND	7
	ADD	A, 3
@1:	LD	C, A
	LD	B, 0		; BC = length

	LDIR
	POP	HL
	POP	BC
	JR	Decomp_loop

LZSS_2:
	DEC	BC
	DEC	BC
	PUSH	BC
	LD	A, (HL)
	CPL
	INC	HL
	LD	C, (HL)
	INC	HL
	PUSH	HL
	LD	H, 0FFh
	LD	L, A
	LD	A, C
	CPL
	ADD	A, A
	ADC	HL, HL
	ADD	A, A
	ADC	HL, HL
	INC	HL
	ADD	HL, DE		; HL = src

	LD	A, C
	AND	03Fh
	ADD	A, 4
	JR	@1b

;;;	DB	40, 15
KBD_PIC:
	DB	05Ch,078h,078h,05Fh,0C6h,000h,0C7h,05Dh,000h,0C6h,000h,04Ah,0C1h,0F0h,0C1h,0F9h
	DB	078h,05Dh,079h,006h,021h,079h,006h,022h,079h,006h,023h,079h,006h,024h,079h,006h
	DB	025h,079h,0C6h,00Ah,00Bh,079h,009h,00Eh,013h,079h,004h,005h,00Ch,079h,01Ch,078h
	DB	078h,01Fh,0C6h,000h,0C7h,01Dh,0C6h,014h,00Bh,0C1h,0F0h,0C1h,0F9h,0C6h,006h,00Dh
	DB	0C6h,003h,0D5h,0C6h,028h,001h,0C6h,000h,096h,0C6h,026h,0C0h,0C6h,020h,042h,007h
	DB	012h,079h,021h,079h,022h,079h,023h,079h,024h,079h,025h,079h,026h,079h,027h,079h
	DB	028h,079h,029h,079h,020h,079h,02Ah,079h,06Ah,079h,06Bh,079h,000h,002h,012h,00Bh
	DB	079h,000h,05Ch,078h,05Dh,000h,01Eh,078h,078h,01Fh,05Fh,0C6h,000h,096h,078h,078h
	DB	078h,05Eh,000h,079h,050h,079h,000h,079h,0A5h,085h,092h,079h,011h,079h,017h,079h
	DB	005h,079h,012h,079h,014h,079h,019h,079h,015h,079h,009h,079h,00Fh,079h,010h,079h
	DB	055h,079h,068h,079h,02Bh,079h,094h,095h,000h,079h,05Ch,01Fh,05Fh,01Fh,05Dh,01Eh
	DB	078h,078h,0C6h,014h,058h,0C6h,014h,000h,079h,045h,079h,040h,079h,079h,003h,014h
	DB	012h,00Ch,079h,001h,079h,013h,079h,004h,079h,006h,079h,007h,079h,008h,079h,00Ah
	DB	079h,00Bh,079h,00Ch,079h,02Ch,079h,04Fh,079h,069h,079h,000h,003h,012h,000h,079h
	DB	01Ch,05Fh,01Fh,05Fh,01Dh,0C6h,014h,000h,0C6h,028h,096h,0C6h,03Ch,000h,05Eh,000h
	DB	079h,080h,079h,000h,079h,013h,008h,009h,006h,014h,079h,01Ah,079h,018h,079h,003h
	DB	079h,016h,079h,002h,079h,00Eh,079h,00Dh,079h,02Fh,079h,02Eh,079h,02Dh,079h,049h
	DB	0C1h,0DCh,000h,01Ch,078h,01Dh,000h,0C6h,05Ch,040h,0C6h,064h,0C0h,01Bh,078h,01Fh
	DB	078h,0C6h,000h,08Ah,0C1h,089h,0C6h,050h,000h,0C6h,068h,0CAh,0C6h,076h,04Ch,0C6h
	DB	004h,090h,0C6h,072h,044h,0C6h,000h,0CAh,0C6h,07Ah,0CAh
KBD_PIC_:
	END	Entry
