;;; $Id: proto-meroon.sc,v 1.2 1992/09/19 15:06:25 queinnec Exp $
;;; Copyright (c) 1990, 91, 92 by Christian Queinnec. All rights reserved.

;;; This file is automatically generated, do not touch.
;;; It allows to compile meroon under Scheme->C and obtain a linkable
;;; meroon.o file. It forms a complete module.

;;; You can compile it saying: 
;;;             scc -c -sch 20 meroon.sc
;;; Warning: it emits a lot of unimportant warnings as well as it requires
;;; a lot of memory to be compiled.

;;; You can use the resulting meroon.o in a new interpreter (yes, the
;;; three meroon macros can be used in this new toplevel) by:
;;; 1- creating a new toplevel module, say sci+meroon.sc, with content:
;;;     (module sci+meroon (with meroon))
;;;     (format stderr-port "With compiled ~A~%" meroon-version)
;;; 2- compiling this new module with:
;;;             scc -i -o sci+meroon sci+meroon.sc meroon.o

;;; This program is distributed in the hope that it will be useful.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted, so long as the following
;;; conditions are met:
;;;      o credit to the authors is acknowledged following current
;;;        academic behaviour
;;;      o no fees or compensation are charged for use, copies, or
;;;        access to this software
;;;      o this copyright notice is included intact.
;;; This software is made available AS IS, and no warranty is made about
;;; the software or its performance.

;;; Bug descriptions, use reports, comments or suggestions are welcome.
;;; Send them to
;;;   <queinnec@polytechnique.fr>   or to:   <Christian.Queinnec@inria.fr>
;;;                                 or to:
;;;   Christian Queinnec                     Christian Queinnec
;;;   Laboratoire d'Informatique de l'X      INRIA -- Rocquencourt
;;;   Ecole Polytechnique                    Domaine de Voluceau, BP 105
;;;   91128 Palaiseau                        78153 Le Chesnay Cedex
;;;   France                                 France

(module meroon)

;;;===========================================================================
;;; This is the copy of a file that defines pervasive macros on top 
;;; of Scheme->C. Very complex: skip till the end of the file...

;;; Insert s2cmac.scm here.
;;; $Id: s2cmac.scm,v 1.5 1992/04/26 11:18:11 queinnec Exp $

;;; To use this file, just include it with its full path
;;;    (include "<directory>/s2cmacros.scm")
;;; or its simple name
;;;    (include "s2cmacros.scm")
;;; but in this case, augment the libraries to be searched with the -I 
;;; option of Scheme->C, something as
;;;    scc -I <directory>/ your-module.sc

;;; This file contains a macro to define macros. The syntax is
;;;    (pervasive-define-macro (macro . parameters) . body)
;;; This macro is highly tied to Scheme->C. 
;;; A pervasive macro reacts to some settings
;;;    (getprop 'define-macro 'verbose) 
;;;         tells verbosely what happens to the macro.
;;;    (getprop 'define-macro 'pervasive)
;;;         defines the macro as really pervasive.
;;; These properties can be installed using the macroexpand-time-eval
;;; macro. You can test if the pervasive macro package is present with
;;;    (getprop 'define-pervasive-macro 'loaded))

;;; When a macro is defined as pervasive, it can be used almost everywhere.
;;; -A- If you load, under the interpreter, a file containing a pervasive 
;;;     macro then you can use it as a macro under the interpreter. 
;;; -B- if you compile a pervasive macro, it can be used in the rest of 
;;;     the compilation, it can be used in the generated application if
;;;     this application is an interpreter or runs the read-eval-print 
;;;     function. 
;;; -C- if you load a pervasive macro under the compiler, then it can be used
;;;     as a macro for the compiler as well as for the interpreter that the
;;;     compiler runs to expand macros.
;;; Pay attention that a pervasive macro generates code so it will be
;;; installed at run-time. The present file can be included for free, 
;;; since it only defines some native Scheme->C macros (with define-macro)
;;; that do not take place in the generated application.

;;; This code uses some innards of Scheme->C (highly unportable)
;;; SCI stores macros under the property *expander* in the Plist of the
;;; symbol that names the macro. SCC stores it under macro under scc.

;;; Define a macro that might be pervasive, tracable...
;;; Syntax: (define-pervasive-macro (name . parameters) . body)
(define-macro define-pervasive-macro
  (lambda (e m)
    (define (map-arguments variables parameters)
      (cond ((pair? variables)
             (cons `( ,(car variables) (car ,parameters) )
                   (map-arguments (cdr variables) `(cdr ,parameters)) ) )
            ((symbol? variables)
             (list `( ,variables ,parameters )) )
            ((null? variables) '()) ) )
    (let* ((call (cadr e))
           (body (cddr e))
           (arity-check
            `(lambda (n)
               (,(if (null? (last-pair call)) `= `<=)
                ,(let count ((variables (cdr call)))
                   (if (pair? variables)
                       (+ 1 (count (cdr variables)))
                       0 ) )
                n ) ) )
           (s2c-expander 
            `(lambda (e m)
               (when (getprop 'define-macro 'ultra-verbose)
                     (format stderr-port "[call macro ~A]~%" e) )
               (unless (,arity-check (length e))
                  (error ',(car call)
                         "Incorrect arity in macro call ~A" e ) )
               (m (let ,(map-arguments (cdr call) '(cdr e))
                    . ,body ) m) ))
           (s2c-installer 
            `(let ((expander ,s2c-expander))
               (putprop ',(car call) '*expander* expander)
               (putprop ',(car call) 'scc 
                        (cons (cons 'macro expander)
                              (or (getprop ',(car call) 'scc)
                                  '() ) ) )
               (putprop ',(car call) 'initial-scc 
                        (cons (cons 'macro expander)
                              (or (getprop ',(car call) 'initial-scc)
                                  '() ) ) )
               ,(if (getprop 'define-macro 'verbose)
                    `(format stderr-port "[macro ~A installed]~%" 
                             ',(car call) )
                    `#t )
               ',(car call) ) ) )
      (when (getprop 'define-macro 'verbose)
            (format stderr-port "[install macro ~A]~%" (car call)) )
      (eval s2c-installer)
      (m (if (getprop 'define-macro 'pervasive)
             s2c-installer
             `',(car call) ) m) ) ) )

;;; Perform some evaluation at macroexpansion time.
;;; Syntax: (macroexpand-time-eval . body)
(define-macro macroexpand-time-eval
  (lambda (e m)
    (let ((verbose (getprop 'define-macro 'verbose)))
      (when verbose
            (format stderr-port "[macroexpand-time-eval ~A" e) )
      (eval `(begin . ,(cdr e)))
      (when verbose
            (format stderr-port "]~%") )
      (m ''done m) ) ) )

;;; Defines a macro that will autoload a file.
;;; Syntax: (define-autoload name . filenames)
;;; Filenames are related to the (getprop 'define-autoload 'home)
;;; directory which is initialized to HOME with a trailing slash.
(define-macro define-autoload 
  (lambda (e m)
    (let ((name (cadr e))
          (filenames (cddr e)) )
      (m `(define-pervasive-macro (,name . parameters)
            (for-each 
             (lambda (filename)
               (when (getprop 'define-macro 'verbose)
                     (format stderr-port "[AutoLoad ~A... " filename) )
               (loadq (string-append (getprop 'define-autoload 'home)
                                     filename ))
               (when (getprop 'define-macro 'verbose)
                     (format stderr-port "]~%") ) )
             ',filenames )
            (cons ',name parameters) )
         m ) ) ) )

;;; This allows the previous macros to be used at macroexpand-time
;;; (with load for example).
(macroexpand-time-eval
 ;; Indicate that the pervasive macros package is loaded.
 (putprop 'define-pervasive-macro 'loaded #t)
 ;; Inquire the environment to know the home directory
 (let ((dir (read (open-process "/bin/echo \\\"${HOME}/\\\"" "r"))))
   (putprop 'define-autoload 'home dir) )
 ;; Retrofit the previous macros so that they can be used in many contexts.
 (let ((macros '(define-pervasive-macro 
                  define-autoload 
                  macroexpand-time-eval )))
   (define (duplicate name)
     (let ((expander (assq 'macro (getprop name 'scc))))
       (when expander 
             (putprop name 'initial-scc 
                      (cons (cons 'macro (cdr expander))
                            (or (getprop name 'initial-scc)
                                '() )  ) )
             (putprop name '*expander* (cdr expander)) ) )
     (let ((expander (getprop name '*expander*)))
       (when expander 
             (putprop name 'scc (cons (cons 'macro expander)
                                      (or (getprop name 'scc)
                                          '() ) ))
             (putprop name 'initial-scc 
                      (cons (cons 'macro expander)
                            (or (getprop name 'initial-scc)
                                '() ) ) ) ) ) )
   ;; The duplicate function may be useful in other contexts so share it
   (putprop 'define-pervasive-macro 'duplicate duplicate)
   (for-each duplicate macros) ) )

;;; These macros do not take place since actually, macros are not
;;; really pervasive.

;;; Autoload the meroon system from the real sources.
(define-autoload define-class   "DEA/meroon/meroon.s2c"
                                "DEA/meroon/meroon.scm" )
(define-autoload define-generic "DEA/meroon/meroon.s2c"
                                "DEA/meroon/meroon.scm" )
(define-autoload define-method  "DEA/meroon/meroon.s2c"
                                "DEA/meroon/meroon.scm" )

;;; Autoload extend-syntax
(define-autoload extend-syntax  "s2c/extend-syntax.scm" )

;;; Local Variables:
;;; mode: scheme
;;; End:

;;;===========================================================================
;;; This allows to load meroon so that meroon can be compiled.

(macroexpand-time-eval
 (putprop 'define-macro 'pervasive #f)
 (putprop 'define-macro 'verbose #f)
 (putprop 'define-macro 'ultra-verbose #f)
 (load "meroon.s2c") 
 (load "meroon.scm") 
 (putprop 'define-macro 'pervasive #t) ) 

(include "meroon.s2c")

(include "meroon.scm")

;;; make it mutable from outside this module.
(set! oo-error oo-error)
