(define (make-stack)
	(define s '())
	(define (push x)
		(set! s (cons x s)))
	(define (pop)
		(if (null? s)
			(error "Empty stack -- POP")
			(let ((top (car s)))
				(set! s (cdr s))
				top)))
	(define (empty?)
		(null? s))
	(define (print)
		(write s))
	(define (stack->list)
		s)
	(define (initialize)
		(set! s '()))
	(define (dispatch message)
		(cond ((eq? message 'push) push)
			  ((eq? message 'pop) (pop))
			  ((eq? message 'empty?) (empty?))
			  ((eq? message 'print) (print))
			  ((eq? message 'stack->list) (stack->list))
			  ((eq? message 'initialize) (initialize))
			  (else (error "Unknown request -- STACK" message))))
	dispatch)

(define (push stack value)
	((stack 'push) value))

(define (pop stack)
	(stack 'pop))

(define (empty? stack)
	(stack 'empty?))

(define (initialize stack)
	(stack 'initialize))

