;;
;; disasm.scm
;;

;;;;    A Disassemble Pakage for SECDR Scheme
;;;
;;;     Date written    28-May-1992 by Shoichi Hayashi
;;;
;;========================================================================
;;
;; RCS info: $Header: /usr/PDS/lang/Scheme/Mulasame/RCS/disasm.scm,v 0.2 1994/09/14 02:55:46 s-haya Exp s-haya $
;;

(define (disassemble code)
  (printf "~%  ************ DisAssemble Code ************~%~%    (~%")
  (disasm-list code 4)
  (printf "    )~%  ************ END DisAssemble ************~%~%"))

(define (disasm-list code indent)
  ;;
  ;;; Definition of operator numbers
  ;;
  (define %LD% '#0)
  (define %TLD% '#1)
  (define %GLD% '#2)
  (define %LDC% '#3)
  (define %LDF% '#4)
  (define %AP% '#5)
  (define %TAP% '#6)
  (define %PUSH% '#7)
  (define %RTN% '#8)
  (define %SEL% '#9)
  (define %TSEL% '#10)
  (define %ASSIG% '#11)
  (define %TASSIG% '#12)
  (define %GASSIG% '#13)
  (define %DEF% '#14)
  (define %PUSHCONS% '#15)
  (define %SAVE% '#16)
  (define %EXEC% '#17)
  (define %STOP% '#18)

  (cond ((null? code)
	 #v)
	((eq? %LD% (car code))
	 (spaces indent)
	 (printf "LD        ~S~%" (cadr code))
	 (disasm-list (cddr code) indent))
	((eq? %TLD% (car code))
	 (spaces indent)
	 (printf "TLD       ~S~%" (cadr code))
	 (disasm-list (cddr code) indent))
	((eq? %GLD% (car code))
	 (spaces indent)
	 (printf "GLD       ~S~%" (cadr code))
	 (disasm-list (cddr code) indent))
	((eq? %LDC% (car code))
	 (spaces indent)
	 (printf "LDC       ~S~%" (cadr code))
	 (disasm-list (cddr code) indent))
	((eq? %LDF% (car code))
	 (spaces indent)
	 (if (pair? (cadr code))
	     (begin
	       (printf "LDF       (~%")
	       (disasm-list (cadr code) (+ indent 4))
	       (spaces (+ indent 4))
	       (printf ")~%"))
	     (printf "LDF       ~S~%" (cadr code)))
	 (disasm-list (cddr code) indent))
	((eq? %AP% (car code))
	 (spaces indent)
	 (printf "AP~%")
	 (disasm-list (cdr code) indent))
	((eq? %TAP% (car code))
	 (spaces indent)
	 (printf "TAP~%")
	 (disasm-list (cdr code) indent))
	((eq? %PUSH% (car code))
	 (spaces indent)
	 (printf "PUSH~%")
	 (disasm-list (cdr code) indent))
	((eq? %RTN% (car code))
	 (spaces indent)
	 (printf "RTN~%")
	 (disasm-list (cdr code) indent))
	((eq? %SEL% (car code))
	 (spaces indent)
	 (if (pair? (cadr code))
	     (begin
	       (printf "SEL       (~%")
	       (disasm-list (cadr code) (+ indent 4))
	       (spaces (+ indent 4))
	       (printf ")~%"))
	     (printf "SEL       ~S~%" (cadr code)))
	 (spaces indent)
	 (if (pair? (caddr code))
	     (begin
	       (printf "    (~%")
	       (disasm-list (caddr code) (+ indent 4))
	       (spaces (+ indent 4))
	       (printf ")~%"))
	     (printf "          ~S~%" (caddr code)))
	 (disasm-list (cdddr code) indent))
	((eq? %TSEL% (car code))
	 (spaces indent)
	 (if (pair? (cadr code))
	     (begin
	       (printf "TSEL      (~%")
	       (disasm-list (cadr code) (+ indent 4))
	       (spaces (+ indent 4))
	       (printf ")~%"))
	     (printf "TSEL      ~S~%" (cadr code)))
	 (spaces indent)
	 (if (pair? (caddr code))
	     (begin
	       (printf "    (~%")
	       (disasm-list (caddr code) (+ indent 4))
	       (spaces (+ indent 4))
	       (printf ")~%"))
	     (printf "          ~S~%" (caddr code)))
	 (disasm-list (cdddr code) indent))
	((eq? %TSEL% (car code))
	 (spaces indent)
	 (printf "TSEL~%")
	 (disasm-list (cdr code) indent))
	((eq? %ASSIG% (car code))
	 (spaces indent)
	 (printf "ASSIG     ~S~%" (cadr code))
	 (disasm-list (cddr code) indent))
	((eq? %TASSIG% (car code))
	 (spaces indent)
	 (printf "TASSIG    ~S~%" (cadr code))
	 (disasm-list (cddr code) indent))
	((eq? %GASSIG% (car code))
	 (spaces indent)
	 (printf "GASSIG    ~S~%" (cadr code))
	 (disasm-list (cddr code) indent))
	((eq? %DEF% (car code))
	 (spaces indent)
	 (printf "DEF       ~S~%" (cadr code))
	 (disasm-list (cddr code) indent))
	((eq? %PUSHCONS% (car code))
	 (spaces indent)
	 (printf "PUSHCONS~%")
	 (disasm-list (cdr code) indent))
	((eq? %SAVE% (car code))
	 (spaces indent)
	 (printf "SAVE~%")
	 (disasm-list (cdr code) indent))
	((eq? %EXEC% (car code))
	 (spaces indent)
	 (printf "EXEC~%")
	 (disasm-list (cdr code) indent))
	((eq? %STOP% (car code))
	 (spaces indent)
	 (printf "STOP~%")
	 (disasm-list (cdr code) indent))
;	((pair? (car code))
;	 (disasm-list (car code) (1+ indent))
;	 (disasm-list (cdr code) indent))
	(default
	  (error "Unknown OPECODE!"))))
